%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Ciscenje radnog prostora
clear; clc;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Kondenzovana matrica krutosti
%alfa[rad]=alfa[stepenima]*pi/180
%Stap 1 - matrica krutosti i kodni brojevi u GKS
[mk_1_LKS, mk_1_GKS, m_T_1]=mk_Stapa(33*10^6, 0.3*1^3/12, 0.3*1, 4, 90*pi/180, 'k');
ss1=[1 2 3 4 5 6];
%Stap 2 - matrica krutosti i kodni brojevi u GKS
[mk_2_LKS, mk_2_GKS, m_T_2]=mk_Stapa(33*10^6, 0.3*1^3/12, 0.3*1, 3, 90*pi/180, 'k');
ss2=[4 5 6 7 8 9];
%Stap 3 - matrica krutosti i kodni brojevi u GKS
[mk_3_LKS, mk_3_GKS, m_T_3]=mk_Stapa(33*10^6, 0.3*1^3/12, 0.3*1, 3, 90*pi/180, 'k');
ss3=[7 8 9 10 11 12];
%Bitni stepeni slobode
bs=[4 7 10];
%Nebitni stepeni slobode
ns=[5 6 8 9 11 12];
%Niz nizova stepeni slobode stapova
niz_SSS={ss1 ss2 ss3};
%Niz matrica krutosti stapova
niz_MKS={mk_1_GKS mk_2_GKS mk_3_GKS};
%Matrice krutosti sistema Kbb, Kbn, Knb i Knn
Kbb=mk_Sistema(niz_SSS, niz_MKS, bs, bs);
Kbn=mk_Sistema(niz_SSS, niz_MKS, bs, ns);
Knb=mk_Sistema(niz_SSS, niz_MKS, ns, bs);
Knn=mk_Sistema(niz_SSS, niz_MKS, ns, ns);
%Kondenzovana matrica
kc=Kbb-Kbn*Knn^(-1)*Knb;
disp('kc =');disp(kc);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Matrica masa
mc=[25.0 0.0  0.0;
    0.0  25.0 0.0;
    0.0  0.0  20.0];
disp('mc =');disp(mc);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Izbor tipa numericke intergacije
%Metoda centralnih razlika -> 1 (uslovno stabilna: dt<=Tn/pi)
%NEWMARK a=const -> 2 (bezuslovno stabilan)
%Duhamel - numericko resenje -> 3 (bezuslovno stabilan postupak; samo za relativno prigusenje manje od 1)
tipNumerickeInteracije = 2;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Relativno prigusenje prva dva tona
ceta1=0.05;
ceta2=0.05;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Interval numericke integracije
dt=0.005;
%Komentar: preporuka dt<Ti/10
%T1=0.41s (T1/10=0.041s) T2=0.06s (T2/10=0.006s) T3=0.02s (T3/10=0.002s!!!)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Formiranje vektora sila
%Trajanje analize = (brojPodataka-1)*dt = (2000-1)*0.005 = 9.995s
brojPodataka = 2001;%da bi imali i 0s i 10s
brojStepeniSlobode=size(kc,1);
P=zeros(brojStepeniSlobode,brojPodataka);
%Sila uz stepen slobode 1
%Linearno raste od 0.0kN u t=0.0s do 200kN u t=0.1s
for k = 1:1:21
    P(1,k)=(200/0.1)*(k-1)*dt;
end
%Konstantna vrednost 200kN do t=0.2s
for k = 22:1:41
    P(1,k)=200.0;
end
%Linearno opada od 200kN u t=0.2s do 0.0kN u t=10s
for k = 42:1:61
    P(1,k)=-(200/0.1)*(k-1)*dt+600;
end
%Konstantna vrednost 0.0kN u t=0.3s do t=10s
for k = 62:1:brojPodataka
    P(1,k)=0.0;
end
%Sila uz stepen slobode 2
for k = 1:1:brojPodataka
    P(2,k)=0.0;
end
%Sila uz stepen slobode 3
for k = 1:1:brojPodataka
    P(3,k)=0.0;
end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Svojstvene vrednosti
[ModalnaMatrica,SpektralnaMatrica]=eig(kc,mc);
[spektralneVrednosti, ind] = sort(diag(SpektralnaMatrica));
SpektralnaMatrica = SpektralnaMatrica(ind,ind);
ModalnaMatrica = ModalnaMatrica(:, ind);

w=zeros(length(ModalnaMatrica(:,1)),1);
T=zeros(length(ModalnaMatrica(:,1)),1);
for k = 1:1:(length(ModalnaMatrica(:,1)))
    w(k,1)=sqrt(SpektralnaMatrica(k,k));
    T(k,1)=2*pi/w(k,1);    
end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Matrica prigusenja
omega1=sqrt(SpektralnaMatrica(1,1));
omega2=sqrt(SpektralnaMatrica(2,2));
T1=2*pi/omega1;
T2=2*pi/omega2;
a0=4*pi*(T1*ceta1-T2*ceta2)/(T1^2-T2^2);
a1=(1/pi)*T1*T2*(T1*ceta1-T2*ceta2)/(T1^2-T2^2);
c=a0*mc+a1*kc;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
fprintf('Modalna matrica\nFi =\n');disp(ModalnaMatrica);
fprintf('Spektralna matrica\nOmegaNaKvadrat =\n');disp(num2str(SpektralnaMatrica));
fprintf('\na0 =%.8f\n', a0);
fprintf('a1 =%.8f\n', a1);
fprintf('Matrica prigusenja\nc =\n');disp(c);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Modalne jednacine
u_Po_Tonovima=zeros(length(mc(:,1)),brojPodataka,length(mc(:,1)));%brojStepeniSlobode,brojRezultataNumInt,brojTonova
P_genTona_niz=cell(length(mc(:,1)));
for k = 1:1:length(mc(:,1))%za svaki ton
    disp('---------------------------------------------')
    fprintf('Parametri modalne jednacine:\n');
    fprintf('w%s = %.3f rad/s;   T%s = %.3f s\n\n',num2str(k),w(k,1),num2str(k),T(k,1));
    M_genTonaRacunski=transpose(ModalnaMatrica(:,k))*mc*ModalnaMatrica(:,k);
    FiTonaOrtonormirano=(1/sqrt(M_genTonaRacunski))*ModalnaMatrica(:,k);
    fprintf('Ortonormiran oblik vibracija\n');disp(num2str(FiTonaOrtonormirano));
    M_genTona=transpose(FiTonaOrtonormirano)*mc*FiTonaOrtonormirano;
    fprintf('\nM_gen = %.3f\n',M_genTona);
    C_genTona=transpose(FiTonaOrtonormirano)*c*FiTonaOrtonormirano;
    fprintf('C_gen = %.3f\n',C_genTona);
    K_genTona=transpose(FiTonaOrtonormirano)*kc*FiTonaOrtonormirano;
    fprintf('K_gen = %.3f\n',K_genTona);
    cetaTona=C_genTona/(2*w(k,1)*M_genTona);
    fprintf('ceta = %.3f\n',cetaTona);
    P_genTona=transpose(FiTonaOrtonormirano)*P;%vektor vrsta
    P_genTona_niz(k)={P_genTona};%ovaj niz se koristi posle za grafik
    [u, v, a, t]=NISDOF(M_genTona, C_genTona, K_genTona, transpose(P_genTona), brojPodataka, dt, tipNumerickeInteracije);
    %u, v, a, t su vektori kolone
    u_Tona=zeros(length(mc(:,1)),length(t));%(brojStepeniSlobode,brojRezultataNumInt)
    for i = 1:1:length(u_Tona(:,1))%za svaki stepen slobode
        for j = 1:1:length(t)%za svaki rezultat numericke integracije
            %Vrste su stepeni slobode; Kolone su rezultati numericke integracije
            u_Tona(i,j)=FiTonaOrtonormirano(i,1)*u(j);
        end
    end
    %Prvi znak : su vrste - stepeni slobode
    %Drugi znak : su kolone - rezultati numericke integracije
    %k - ton
    u_Po_Tonovima(:,:,k)=u_Tona;
end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Ukupno relativno pomeranje
u_ukupno=zeros(length(mc(:,1)),brojPodataka);
for i = 1:1:length(mc(:,1))%za svaki ton
    for j = 1:1:length(mc(:,1))%za svaki stepen slobode
        for k = 1:1:brojPodataka%za svaki rezultat numericke integracije
            u_ukupno(j,k)=u_ukupno(j,k)+u_Po_Tonovima(j,k,i);
        end
    end
end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Grafici
%Proredjivanje crtanja tacaka na grafiku (npr. 2 predstavlja crtanje svake druge tacke)
gustina=1;
figure('Name','Pomeranje','NumberTitle','off');
%Pomeranje - ukupno
for i = 1:1:length(mc(:,1))%za svaki stepen slobode
    subplot(length(mc(:,1)),1,i);
    plot(t(1:gustina:end,1),u_ukupno(i,1:gustina:end), 'r', 'linewidth', 2);
    grid;
    xlabel('t');
    ylabel(strcat('u(t)'));
    maxU=max(u_ukupno(i,:));
    minU=min(u_ukupno(i,:));
    imeTipaNumerickeIntegracije = '';
    if tipNumerickeInteracije == 1
        imeTipaNumerickeIntegracije = ' - Metoda centralnih razlika';
    elseif tipNumerickeInteracije == 2
        imeTipaNumerickeIntegracije = ' - NEWMARK a=const';
    elseif tipNumerickeInteracije == 3
        imeTipaNumerickeIntegracije = ' - Duhamel';
    end
    title(strcat('Stepen slobode-',num2str(i),': umax=',num2str(maxU,5),' umin=',num2str(minU,5),imeTipaNumerickeIntegracije));
end

%Pomeranje - udeo po tonovima
%Naslov grafika u kome se vide periodi vibracija
naslov='Pomeranje - udeo po tonovima --';
for i = 1:1:length(mc(:,1))
    naslov=strcat(naslov,'T',num2str(i),'=',num2str(T(i,1)),'s--');
end
figure('Name',naslov,'NumberTitle','off');
for i = 1:1:length(mc(:,1))%za svaki stepen slobode
    subplot(length(mc(:,1)),1,i);
    tempRezPomeranja = '';
    hold on;
    for j = 1:1:length(mc(:,1))%za svaki ton
        u_Tona=u_Po_Tonovima(i,:,j);
        maxU=max(u_Tona(1,:));
        minU=min(u_Tona(1,:));
        plot(t(1:gustina:end,1),u_Tona(1,1:gustina:end));
        tempRezPomeranja=strcat(tempRezPomeranja,' umax',num2str(j),'=',num2str(maxU,5));
        tempRezPomeranja=strcat(tempRezPomeranja,' umin',num2str(j),'=',num2str(minU,5),'; ');
    end
    grid;
    xlabel('t');
    ylabel('u(t)');
    lgd = legend;
    title(lgd,'Broj je ton');
    title(strcat('Stepen slobode-',num2str(i),' (',naslov,')'));
    hold off;
    disp('---------------------------------------------');
    disp(strcat('Stepen slobode-',num2str(i)));
    disp(tempRezPomeranja);
end

%Sila
figure('Name','Sila i generalisana sila','NumberTitle','off');
for k = 1:1:brojStepeniSlobode
    %Trenutni grafik
    subplot(2,brojStepeniSlobode,k);
    plot(t(1:gustina:end,1),P(k,1:gustina:end));
    title(strcat('Sila:',num2str(k),' stepen slobode'));
    grid;
    xlabel('t[s]');
    ylabel('P[kN]');
end

%Generalisana sila
for k = 1:1:brojStepeniSlobode
    %Trenutni grafik
    subplot(2,brojStepeniSlobode,k+brojStepeniSlobode);
    P_genTona=transpose(P_genTona_niz{k});
    plot(t(1:gustina:end,1),P_genTona(1:gustina:end,1));
    title(strcat('Generalisana sila: T',num2str(k),'=',num2str(T(k,1)),' s'));
    grid;
    xlabel('t[s]');
    ylabel('Pgen[kN]');
end